Graphics3D 640,360,0,2
SetBuffer BackBuffer()
HidePointer

;
; Include the ParseB3D functions
; These are used to extract the information from
; the entity names, saved by gile[s]
Include "ParseB3D.bb"

;
; Types
Type emitter
	Field parent,rate#,time#
	Field texture,blend
	Field speed#,spread#,life#,size#,growth#,gravity#
End Type

Type particle
	Field sprite
	Field x#,y#,z#
	Field sx#,sy#,sz#
	Field life#,lifespan#,size#,growth#,gravity#
End Type

Type player
	Field pivot
	Field camera
	Field x#,y#,z#
	Field speedx#,speedy#,speedz#
	Field rotx#,roty#,rotz#
	Field turnx#,turny#
End Type

Type flare
	Field sprite
	Field texture
	Field alpha#,talpha#
End Type

;
; FPS Limiter
Global FRate  
Global ftime1,ftime2,ftime3,ftime4
SetFPSLimit(50)

;
; Collision set up
Const C_PLAYER 	= 1
Const C_LEVEL	= 2
Collisions C_PLAYER,C_LEVEL,2,2

;
; Particle stuff
Global particlecount = 0
Global maxparticles  = 400

;
; Create a player
player.player = CreatePlayer()

;
; Load the scene exported by gile[s]
scene = LoadAnimMesh("romanbath.b3d")
EntityType scene,C_LEVEL,True
EntityPickModeRec scene,2,True

;
; Parse the loaded B3D file for lights and custom properties
; See the ParseB3D include to see how it's done!
ParseB3D(scene)

;
; Create Flares at omni light positions
CreateFlares()

;
; Create a sky
; This could also have been done via Custom Properties
sky = CreateSphere()
RotateEntity sky,90,0,0
ScaleEntity sky,2000,2000,2000
FlipMesh sky
skytex = LoadTexture("stars.tga")
ScaleTexture skytex,0.2,0.6
EntityTexture sky,skytex
EntityOrder sky,1

;
; Create some cubemapped water
; (only if cube mapping is supported)
; This could also have been done via Custom Properties
Global waterang# = 0.0
water=CreateFace(10,20)
ScaleEntity water,120,1,320
PositionEntity water,0,-5,0
EntityFX water,1
EntityColor water,160,180,255
EntityAlpha water,0.5
If GfxDriverCaps3D() => 110
	ClearTextureFilters
	watertex=CreateTexture(256,256,1+128+256)
	EntityTexture water,watertex
	cube_cam=CreateCamera()
End If

;
; Main loop
While Not KeyDown(1)

	LimitFPS()

	UpdateEmitters()
	UpdateParticles()
	UpdatePlayers()
	UpdateFlares(player)
	UpdateWater(water)

	UpdateWorld
	UpdateCubemap(watertex,cube_cam,water,player\camera)
	RenderWorld 
	
	Flip 		

Wend

End

Function CreateFlares()
	
	For light.light = Each light
		If light\typ = LIGHT_OMNI
			flare.flare = New flare
			flare\sprite = CreateSprite(light\entity)
			flare\texture = LoadTexture("flare.bmp")
			EntityBlend flare\sprite,3
			EntityFX flare\sprite,1
			EntityTexture flare\sprite,flare\texture
			ScaleSprite flare\sprite,10.0,10.0
			EntityOrder flare\sprite,-1
			EntityPickMode flare\sprite,1
		End If
	Next
	
End Function

Function UpdateFlares(player.player)

	For flare.flare = Each flare
		If EntityVisible(player\camera,flare\sprite)
			flare\talpha = 1.0
		Else
			flare\talpha = 0.0
		End If
		flare\alpha = flare\alpha - (flare\alpha - flare\talpha)*0.2		
		grey = Rand(200,255)*flare\alpha
		EntityColor flare\sprite,grey,grey,grey
		size# = Rnd(9.5,10.5)
		ScaleSprite flare\sprite,size,size
	Next
	
End Function

Function CreatePlayer.player()

	pl.player = New player
	pl\pivot = CreatePivot()
	pl\camera = CreateCamera(pl\pivot)
	PositionEntity pl\camera,0,40,0
	CameraClsColor pl\camera,20,40,45
	CameraRange	pl\camera,1.0,10000.0

	pl\x = 0
	pl\y = 30
	pl\z = 200
	PositionEntity pl\pivot,pl\x,pl\y,pl\z	
	RotateEntity pl\pivot,0,180,0
	
	EntityRadius pl\pivot,5,20
	EntityType pl\pivot,C_PLAYER

	Return pl
	
End Function

Function UpdatePlayers()

	For pl.player = Each player
		If KeyDown(200) Then pl\speedz = pl\speedz + 0.2
		If KeyDown(208) Then pl\speedz = pl\speedz - 0.1
		If KeyDown(203) Then pl\speedx = pl\speedx - 0.1
		If KeyDown(205) Then pl\speedx = pl\speedx + 0.1
		
		pl\turny = pl\turny - (MouseXSpeed()*0.02)
		pl\turnx = pl\turnx - (MouseYSpeed()*0.02)
		
		pl\turnx = pl\turnx * 0.95
		pl\turny = pl\turny * 0.95
		
		pl\speedx = pl\speedx * 0.95
		pl\speedy = pl\speedy - 0.05
		pl\speedz = pl\speedz * 0.95
		
		If EntityCollided(pl\pivot,C_LEVEL)
			For i = 1 To CountCollisions(pl\pivot)
				pl\speedy = pl\speedy * (1.0-CollisionNY(pl\pivot,i))
			Next
		End If
		
		TurnEntity pl\pivot,0,pl\turny,0
		TurnEntity pl\camera,pl\turnx,0,0
		
		If EntityPitch(pl\camera)<-80.0
			RotateEntity pl\camera,-80,0,0
		ElseIf EntityPitch(pl\camera)>80.0
			RotateEntity pl\camera,80,0,0
		End If
		
		MoveEntity pl\pivot,pl\speedx,0,pl\speedz
		TranslateEntity pl\pivot,0,pl\speedy,0
		
		MoveMouse GraphicsWidth()/2,GraphicsHeight()/2
	Next

End Function

Function UpdateEmitters()

	For emitter.emitter = Each emitter
	
		emitter\time = emitter\time + emitter\rate
	
		While emitter\time>1.0
			If particlecount<maxparticles
				p.particle = New particle
	
				p\sprite = CreateSprite()
				If emitter\texture
					EntityTexture p\sprite,emitter\texture
				End If
				ScaleSprite p\sprite,emitter\size,emitter\size
				EntityBlend p\sprite,emitter\blend
	
				p\x = EntityX(emitter\parent,True)
				p\y = EntityY(emitter\parent,True)
				p\z = EntityZ(emitter\parent,True)
	
				TFormNormal 0,1,0,emitter\parent,0
	
				p\sx = (TFormedX() + Rnd(-emitter\spread,emitter\spread)) * emitter\speed
				p\sy = (TFormedY() + Rnd(-emitter\spread,emitter\spread)) * emitter\speed
				p\sz = (TFormedZ() + Rnd(-emitter\spread,emitter\spread)) * emitter\speed
	
				p\life = emitter\life
				p\lifespan = emitter\life
	
				p\size = emitter\size
				p\growth = emitter\growth
			
				p\gravity = emitter\gravity	
	
				PositionEntity p\sprite,p\x,p\y,p\z
		
				particlecount = particlecount+1
			End If
			
			emitter\time = emitter\time - 1
		Wend 
	Next
	
End Function

Function UpdateParticles()

	For p.particle = Each particle
		p\x = p\x + p\sx
		p\y = p\y + p\sy
		p\z = p\z + p\sz
		
		p\sx = p\sx * 0.98
		p\sy = p\sy + p\gravity
		p\sz = p\sz * 0.98
		
		p\life = p\life - 1
		
		p\size = p\size + p\growth
		
		If p\life <= 0
			particlecount = particlecount - 1
			FreeEntity p\sprite
			Delete p
		Else
			RotateSprite p\sprite,p\life*2.0
			PositionEntity p\sprite,p\x,p\y,p\z
			EntityAlpha p\sprite,p\life/p\lifespan		
			ScaleSprite p\sprite,p\size,p\size
		End If
	Next

End Function

Function UpdateWater(mesh)
	
	If mesh 
		n_surf = CountSurfaces(mesh)
		For s = 1 To n_surf
			surf = GetSurface(mesh,s)
			n_vert = CountVertices(surf)-1
			For v = 0 To n_vert
				d# = 1.0-(VertexX(surf,v)*VertexX(surf,v) + VertexZ(surf,v)*VertexZ(surf,v))
				VertexCoords surf,v,VertexX(surf,v),Sin(waterang+(d*60)+(v*30))*d*0.1,VertexZ(surf,v) 
			Next
		Next
	
		UpdateNormals mesh
		waterang = waterang + 15
	End If

End Function

;
; From the cubemap example
Function UpdateCubemap(tex,camera,entity,ocam,flat=True,refraction=True)

	If tex<>0 
		CameraProjMode ocam,0
		CameraRange	camera,1.0,10000.0
	
		tex_sz=TextureWidth(tex)

		; Show the camera we have specifically created for updating the cubemap
		ShowEntity camera
	
		; Hide entity that will have cubemap applied to it. This is so we can get cubemap from its position, without it blocking the view
		HideEntity entity

		; Position camera where the entity is - this is where we will be rendering views from for cubemap
		If flat
			PositionEntity camera,EntityX#(ocam,True),EntityY#(entity,True)-(EntityY(ocam,True)-EntityY(entity,True)),EntityZ(ocam,True)
		Else
			PositionEntity camera,EntityX#(entity,True),EntityY#(entity,True),EntityZ#(entity,True)
		End If

		CameraClsMode camera,False,True
	
		; Set the camera's viewport so it is the same size as our texture - so we can fit entire screen contents into texture
		CameraViewport camera,0,0,tex_sz,tex_sz

		; Update cubemap

		; do left view	
		SetCubeFace tex,0
		RotateEntity camera,0,90,0
		RenderWorld
		CopyRect 0,0,tex_sz,tex_sz,0,0,BackBuffer(),TextureBuffer(tex)
	
		; do forward view
		SetCubeFace tex,1
		RotateEntity camera,0,0,0
		RenderWorld
		CopyRect 0,0,tex_sz,tex_sz,0,0,BackBuffer(),TextureBuffer(tex)
	
		; do right view	
		SetCubeFace tex,2
		RotateEntity camera,0,-90,0
		RenderWorld
		CopyRect 0,0,tex_sz,tex_sz,0,0,BackBuffer(),TextureBuffer(tex)
	
		; do backward view
		SetCubeFace tex,3
		RotateEntity camera,0,180,0
		RenderWorld
		CopyRect 0,0,tex_sz,tex_sz,0,0,BackBuffer(),TextureBuffer(tex)
	
		; do up view
		SetCubeFace tex,4
		RotateEntity camera,-90,0,0
		RenderWorld
		CopyRect 0,0,tex_sz,tex_sz,0,0,BackBuffer(),TextureBuffer(tex)

		; do down view
		SetCubeFace tex,5
		RotateEntity camera,90,0,0
		RenderWorld
		CopyRect 0,0,tex_sz,tex_sz,0,0,BackBuffer(),TextureBuffer(tex)
	
		; Show entity again
		ShowEntity entity
	
		; Hide the cubemap camera
		HideEntity camera

		CameraProjMode ocam,1
	End If
		
End Function

;
; Creates a single sided face segmented
; From the code archives
Function CreateFace(ysegs=1,xsegs=1,parent=0)
	mesh=CreateMesh( parent )
	surf=CreateSurface( mesh )
	stx#=-.5
	sty#=stx
	xstp#=Float(1)/Float(xsegs)
	ystp#=Float(1)/Float(ysegs)
	y#=sty
	For a=0 To xsegs
		x#=stx
		v#=a/Float(xsegs)
		For b=0 To ysegs
			u#=b/Float(ysegs)
			AddVertex(surf,x,0,y,u,v) ; swap these for a different start orientation
			x=x+xstp
		Next
		y=y+ystp
	Next
	
	For a=0 To xsegs-1
		For b=0 To ysegs-1
			v0=a*(ysegs+1)+b:v1=v0+1
			v2=(a+1)*(ysegs+1)+b+1:v3=v2-1
			AddTriangle( surf,v0,v2,v1 )
			AddTriangle( surf,v0,v3,v2 )
		Next	
	Next
	UpdateNormals mesh
	
	FitMesh mesh,-0.5,-0.5,-0.5,1,1,1
	
	Return mesh
End Function

;
; Courtesy of Bouncer
Function SetFPSLimit(f)
	frate=(1000/f)
End Function

Function LimitFPS()
	ftime2 = MilliSecs() 
	ftime3 = ftime2 - ftime1 
	ftime4 = fRate - ftime3 
	Delay ftime4 
	ftime1 = MilliSecs() 
End Function

;
; Recursive EntityPickmode
Function EntityPickmodeRec(entity,pick_geometry,obscurer=False)

	If entity = 0 Then Return

	EntityPickMode entity,pick_geometry,obscurer

	;
	; Go through the children of this entity
	children = CountChildren(entity)
	For child = 1 To children
		EntityPickmodeRec(GetChild(entity,child),pick_geometry,obscurer)
	Next
	
End Function
